// Mit rekursiver GGT-Ermittlung

public class Bruch {
	private int zaehler;          // wird automatisch mit 0 initialisiert
	private int nenner = 1;       // wird manuell mit 1 initialisiert
	private String etikett = "";  // die Referenztyp-Init. auf null wird ersetzt

    private static int anzahl;    // wird automatisch mit 0 initialisiert

    public Bruch(int z, int n, String eti) {
        setzeZaehler(z);
        setzeNenner(n);
        setzeEtikett(eti);
        anzahl++;
    }

    public Bruch() {anzahl++;}

	public void setzeZaehler(int z) {zaehler = z;}

//    public void setzeZaehler(int zaehler) {
//        this.zaehler = zaehler;
//    }

	public boolean setzeNenner(int n) {
		if (n != 0) {
			nenner = n;
			return true;
		} else
			return false;
	}

	public void setzeEtikett(String eti) {
		if (eti.length() <= 40)
			etikett = eti;
		else
			etikett = eti.substring(0, 40);
	}

	public int gibZaehler() {return zaehler;}

	public int gibNenner() {return nenner;}

	public String gibEtikett() {return etikett;}

    private int ggTr(int a, int b) {
        int rest = a % b;
        if (rest == 0)
            return Math.abs(b);
        else
            return ggTr(b, rest);
    }

    private int ggTi(int a, int b) {
        int rest;
        do {
            rest = a % b;
            a = b;
            b = rest;
        } while (rest > 0);
        return Math.abs(a);
    }

    public void kuerze() {
        if (zaehler != 0) {
            int ggt = ggTr(zaehler, nenner);
            zaehler /= ggt;
            nenner  /= ggt;
        } else
            nenner = 1;
    }

	public void addiere(Bruch b) {
		zaehler = zaehler*b.nenner + b.zaehler*nenner;
		nenner = nenner*b.nenner;
		kuerze();
	}

    public boolean addiere(int z, int n, boolean autokurz) {
        if (n != 0) {
            zaehler = zaehler*n + z*nenner;
            nenner = nenner*n;
            if (autokurz)
                kuerze();
            return true;
        } else
            return false;
    }

    public void addiere(Bruch... bar) {
        for (Bruch b : bar)
            addiere(b);
    }

    public void dupliziere(Bruch bc) {
        bc.zaehler = zaehler;
        bc.nenner = nenner;
        bc.etikett = etikett;
    }

    public Bruch klone() {
        return new Bruch(zaehler, nenner, etikett);
    }

    public static int hanz() {
        return anzahl;
    }

    public void frage() {
		int n;
		do {
			setzeZaehler(Simput.gint("Zähler: "));
		} while (Simput.checkError());
		do {
			// Bei irregulärer Eingabe liefert gint() eine 0 und setzt einen Fehlerindikator.
			n = Simput.gint("Nenner: ");
			if (n == 0 && !Simput.checkError())
				IO.println("Der Nenner darf nicht Null werden!\n");
		} while (n == 0);
		setzeNenner(n);
	}

	public void zeige() {
		String luecke = "";
		final int el = etikett.length();
		for (int i = 1; i <= el; i++)
			luecke = luecke + " ";
		IO.println(" " + luecke  + "   " + zaehler + "\n" +
                   " " + etikett + " -----\n" +
                   " " + luecke  + "   " + nenner + "\n");
	}
}